
rm(list = ls())

library("dplyr")
library("readxl")
library("writexl")
library("ggplot2")
library("sf")

archivo_entrada = "a. 2PLAY1.xlsx"
mapa_salida = "b. 2PL1_mapa.png"
histograma_salida = "c. 2PL1_histograma.png"

DATA <- read_excel(archivo_entrada)
DATA <- mutate(DATA, IHH_PREVIO=ifelse(IHH_PREVIO==0, NA, IHH_PREVIO))

SF <- st_read("MGN_ADM_MPIO_GRAFICO.shp")
SF$ID_MUNICIPIO <- as.numeric(SF$mpio_cdpmp)
SF <- merge(SF, select(DATA, ID_MUNICIPIO, IHH_PREVIO), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)

base_map <- ggplot(data = SF) +
          geom_sf(aes(fill = IHH_PREVIO), color = NA) +
          scale_fill_gradient(low = "white", high = "darkred", limits = c(0, 1)) +
          theme_minimal() + labs(fill = "IHH")

san_andres_map <- ggplot(data = SF) +
                geom_sf(aes(fill = IHH_PREVIO), color = NA) +
                scale_fill_gradient(low = "white", high = "darkred", limits = c(0, 1)) +
                coord_sf(xlim = c(-81.8, -81.3), ylim = c(12.45, 12.65), expand = TRUE) +
                theme_void() + theme(legend.position = "none")

san_andres_grob <- ggplotGrob(san_andres_map)

final_map <- base_map +
  annotation_custom(
    grob = san_andres_grob,
    xmin = -82, xmax = -72, ymin = 2, ymax = 20)

print(final_map)

ggsave(mapa_salida, plot = final_map, width = 14, height = 12, dpi = 300)

MUN_A <- filter(DATA, AFECTADO > 0)

png(histograma_salida, width = 800, height = 400)

par(mfrow = c(1, 2))

hist(MUN_A$IHH_PREVIO, breaks = 10, main="Antes de la integración", col="#26619C", xlab=NULL, ylab=NULL, las=2, xaxt="n", xlim=c(0,1), ylim=c(0,15))
axis(1, at=c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1), las=2, padj=0,
     labels = c(0,1000,2000,3000,4000,5000,6000,7000,8000,9000,10000))
grid(nx = NA,ny = NULL,lty = 2, col = "gray", lwd = 1)

hist(MUN_A$IHH_POSTERIOR, breaks = 10, main="Después de la integración", col="#FF8243", xlab=NULL, ylab=NULL, las=2, xaxt="n", xlim=c(0,1), ylim=c(0,15))
     axis(1, at=c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1), las=2, padj=0,
     labels = c(0,1000,2000,3000,4000,5000,6000,7000,8000,9000,10000))
grid(nx = NA,ny = NULL,lty = 2, col = "gray", lwd = 1)

dev.off()
